import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import ReactModal from 'react-modal';
import { connect } from 'react-redux';
import TableViewer from '../../components/TableViewer';
import ReadonlyRow from './ServiceDashboardValidationResultTable';

class DashboardValidationResultModal extends PureComponent {
    handleConfirm = (event) => {
      this.props.onConfirm(event);
    };

    handleCancel = (event) => {
      this.props.onCancel(event);
    };

    render() {
      const validationIssues = this.props.validationResultsData.validationIssues || [];
      const content = validationIssues && validationIssues.length > 0 ? (
        <TableViewer
          columns={['#', 'Severity', 'Description']}
          values={validationIssues}
          row={ReadonlyRow}
          limit={10}
        />
      ) : <span>Dashboard valid</span>;
      const canConfirm = validationIssues.filter((row) => row.severity !== 'WARN').length === 0;
      const confirmContent = canConfirm ? (
        <button type="button" className="btn btn-danger" onClick={this.handleConfirm}>
          Continue
        </button>
      ) : null;
      return (
        <ReactModal
          className="modal-dialog"
          contentLabel="Modal"
          isOpen={this.props.isOpenValidation}
          onRequestClose={this.handleCancel}
        >
          <div className="modal-content">
            <div className="modal-header">
              <button type="button" className="close" onClick={this.handleCancel}>
                <span>&times;</span>
              </button>
              <h4 className="modal-title">Service dashboard validation results</h4>
            </div>
            <div className="modal-body">
              <div className="form-horizontal">
                {content}
              </div>
            </div>
            <div className="modal-footer">
              <button type="button" className="btn btn-default" onClick={this.handleCancel}>
                Cancel
              </button>
              {confirmContent}
            </div>
          </div>
        </ReactModal>
      );
    }
}

DashboardValidationResultModal.propTypes = {
  isOpenValidation: PropTypes.bool.isRequired,
  onConfirm: PropTypes.func.isRequired,
  onCancel: PropTypes.func.isRequired,
  validationResultsData: PropTypes.object,
};

DashboardValidationResultModal.defaultProps = {
  validationResultsData: {
    validationIssues: [],
  },
};

const mapStateToProps = (state) => ({
  validationResultsData: state.serviceDashboardValidationResult,
});

export default connect(mapStateToProps)(DashboardValidationResultModal);
