import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import ReactModal from 'react-modal';
import FormInput from '../../components/forms/FormInput';

class InputDashboardIdModal extends PureComponent {
  constructor(props) {
    super(props);
    this.state = { dashboardId: '' };
  }

  handleCancel = (event) => {
    this.props.onCancel(event);
  };

  handleConfirm = (event) => {
    event.preventDefault();
    this.props.onConfirm(this.state.dashboardId);
  };

  handleChange = (event) => {
    event.preventDefault();
    this.setState({ dashboardId: event.target.value });
  };

  render() {
    return (
      <ReactModal
        className="modal-dialog"
        contentLabel="Modal"
        isOpen={this.props.isOpen}
        onRequestClose={this.handleCancel}
      >
        <div className="modal-content">
          <div className="modal-header">
            <button type="button" className="close" onClick={this.handleCancel}>
              <span>&times;</span>
            </button>
            <h4 className="modal-title">Synchronize service dashboard</h4>
          </div>
          <div className="modal-body">
            <p>Input the ID of dashboard to synchronize with selected service dashboard:</p>
            <div className="form-horizontal">
              <FormInput
                label="Dashboard ID"
                name="dashboardId"
                type="text"
                value={this.state.dashboardId}
                onChange={this.handleChange}
              />
            </div>
          </div>
          <div className="modal-footer">
            <button type="button" className="btn btn-default" onClick={this.handleCancel}>
              Cancel
            </button>
            <button type="button" className="btn btn-danger" onClick={this.handleConfirm}>
              Synchronize
            </button>
          </div>
        </div>
      </ReactModal>
    );
  }
}

InputDashboardIdModal.propTypes = {
  isOpen: PropTypes.bool.isRequired,
  onConfirm: PropTypes.func.isRequired,
  onCancel: PropTypes.func.isRequired,
};

export default InputDashboardIdModal;
