/* eslint-disable max-classes-per-file */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

function wrapHandler(index, handler) {
  if (!handler) {
    return null;
  }
  return (event) => {
    event.preventDefault();
    event.stopPropagation();
    handler(index);
  };
}

export class ReadonlyRow extends PureComponent {
  constructor(props) {
    super(props);
    this.onClick = wrapHandler(props.index, props.onClick);
    this.onDelete = wrapHandler(props.index, props.onDelete);
  }

  render() {
    const { index, value } = this.props;
    return (
      <tr onClick={this.onClick}>
        <td>{index + 1}</td>
        <td>{value || ''}</td>
        {this.onDelete
        && (
        <td className="actions">
          <button type="button" onClick={this.onDelete}>
            <i className="glyphicon glyphicon-remove" />
          </button>
        </td>
        )}
      </tr>
    );
  }
}

ReadonlyRow.propTypes = {
  index: PropTypes.number.isRequired,
  value: PropTypes.string.isRequired,
  onClick: PropTypes.func,
  onDelete: PropTypes.func,
};

ReadonlyRow.defaultProps = {
  onClick: null,
  onDelete: null,
};

export class EditableRow extends PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      id: props.value || '',
    };
  }

  componentDidMount() {
    this.labelInput.focus();
  }

  onOkClick = (event) => {
    event.preventDefault();
    event.stopPropagation();
    this.doComplete();
  };

  onKeyDown = (event) => {
    if (event.which === 13) {
      event.preventDefault();
      event.stopPropagation();
      this.doComplete();
    } else if (event.which === 27) {
      event.preventDefault();
      this.props.onCancel();
    }
  };

  onInputChange = (event) => {
    const {
      type, value,
    } = event.target;
    if (type === 'text') {
      this.setState({ id: value });
    }
  };

  doComplete() {
    const { onOk, index } = this.props;
    const {
      id,
    } = this.state;
    onOk(index, id);
  }

  render() {
    const { index } = this.props;
    const {
      id,
    } = this.state;
    return (
      <tr onKeyDown={this.onKeyDown}>
        <td>{index >= 0 ? index + 1 : ''}</td>
        <td>
          <input
            type="text" name="label" className="form-control"
            value={id} onChange={this.onInputChange}
            ref={(input) => { this.labelInput = input; }}
          />
        </td>
        <td className="actions">
          <button type="button" onClick={this.onOkClick}>
            <i className="glyphicon glyphicon-ok" />
          </button>
        </td>
      </tr>
    );
  }
}

EditableRow.propTypes = {
  index: PropTypes.number.isRequired,
  value: PropTypes.string,
  onOk: PropTypes.func.isRequired,
  onCancel: PropTypes.func.isRequired,
};

EditableRow.defaultProps = {
  value: '',
};
