/* eslint-disable max-classes-per-file */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';

export default class ReadonlyRow extends PureComponent {
  render() {
    const { index, value } = this.props;
    const severityStyle = value.severity === 'WARN' ? 'warning' : 'danger';
    return (
      <tr onClick={this.onClick}>
        <td>{index + 1}</td>
        <td>
          <span className={`label label-${(severityStyle)}`}>{value.severity || ''}</span>
        </td>
        <td>{value.description || ''}</td>
      </tr>
    );
  }
}

ReadonlyRow.propTypes = {
  index: PropTypes.number.isRequired,
  value: PropTypes.object.isRequired,
};
