import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { bindActionCreators } from 'redux';
import { connect } from 'react-redux';

import Breadcrumb from '../../components/Breadcrumb/Breadcrumb';
import PageTitle from '../../components/PageTitle';
import ServiceProviderForm from './ServiceProviderForm';

import { loadServiceProvider, saveServiceProvider, clearServiceProvider } from '../../store/reducers/serviceProviders/serviceProvider';
import WarningAlert from '../projects/alerts/WarningAlert';

class ServiceProviderEditPage extends PureComponent {
  componentDidMount() {
    const id = this.props.match.params.serviceProviderId || '';

    const { serviceProviderData } = this.props;
    if (id) {
      const loadedId = serviceProviderData.data ? serviceProviderData.data.id : '';
      if (loadedId !== id) {
        this.props.loadServiceProvider(id);
      }
    } else {
      this.props.clearServiceProvider();
    }
  }

  onSubmit = (value) => {
    const id = this.props.match.params.serviceProviderId || '';
    const isNew = !id;

    const { history } = this.props;
    this.props.saveServiceProvider(value, isNew)
      .then(() => history.push(`/admin/serviceProviders/${value.serviceProviderId}`));
  };

  render() {
    const id = this.props.match.params.serviceProviderId || '';
    const isNewServiceProvider = !id;
    const data = this.props.serviceProviderData || {};
    const title = isNewServiceProvider ? 'New service provider' : `Service provider ${id}`;

    let content = null;
    if (data.loading) {
      content = <div>Loading...</div>;
    } else if (data.error) {
      content = <WarningAlert title="Error!" message={data.error} />;
    } else if (isNewServiceProvider || data.data) {
      const serviceProvider = data.data || {};
      content = (
        <ServiceProviderForm
          serviceProvider={serviceProvider}
          isNew={isNewServiceProvider}
          onSubmit={this.onSubmit}
        />
      );
    }

    return (
      <div>
        <Breadcrumb match={this.props.match} />
        <PageTitle title={title} />
        {content}
      </div>
    );
  }
}

ServiceProviderEditPage.propTypes = {
  match: PropTypes.object.isRequired,
  history: PropTypes.object.isRequired,
  serviceProviderData: PropTypes.object.isRequired,
  loadServiceProvider: PropTypes.func.isRequired,
  saveServiceProvider: PropTypes.func.isRequired,
  clearServiceProvider: PropTypes.func.isRequired,
};

const mapStateToProps = (state) => ({
  serviceProviderData: state.serviceProvider,
});

const mapDispatchToProps = (dispatch) => bindActionCreators({
  loadServiceProvider,
  saveServiceProvider,
  clearServiceProvider,
}, dispatch);

export default connect(mapStateToProps, mapDispatchToProps)(ServiceProviderEditPage);
