/* eslint-disable react/no-string-refs */
import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import FormInput from '../../components/forms/FormInput';

import { makeShardId } from '../shards/ShardForm';
import FormDatalist from '../../components/forms/FormDatalist';

class ShardModalForm extends PureComponent {
  constructor(props) {
    super(props);
    this._projectId = props.projectId;
    this._serviceId = props.serviceId;
    this._idFieldTouched = false;
    this.state = { id: '', clusterId: '' };
  }

  componentDidMount() {
    this.refs.clusterField.focus();
  }

  onSubmit = (event) => {
    event.preventDefault();
    this.props.onSubmit();
  };

  onShardIdChange = (event) => {
    this._idFieldTouched = true;
    this.setState({ id: event.target.value });
  };

  onClusterIdChange = (event) => {
    const clusterId = event.target.value;
    const newState = { clusterId };
    if (!this._idFieldTouched) {
      newState.id = makeShardId(this._projectId, clusterId, this._serviceId);
    }
    this.setState(newState);
  };

  stateToValue() {
    const { id, clusterId } = this.state;
    return {
      id, projectId: this._projectId, clusterId, serviceId: this._serviceId,
    };
  }

  render() {
    const { clusters, errorMessage } = this.props;
    const { id, clusterId } = this.state;

    return (
      <form className="form-horizontal" onSubmit={this.onSubmit}>
        {errorMessage && (
          <div className="alert alert-danger">{errorMessage}</div>
        )}
        <FormDatalist
          label="Cluster"
          help="Unique cluster identifier"
          name="clusterId"
          value={clusterId}
          datalist={clusters}
          ref="clusterField"
          onChange={this.onClusterIdChange}
        />
        <FormInput
          type="text"
          name="id"
          label="Id"
          help="Unique shard identifier. It is composed from project, service and cluster id automatically"
          value={id}
          onChange={this.onShardIdChange}
        />
      </form>
    );
  }
}

ShardModalForm.propTypes = {
  onSubmit: PropTypes.func.isRequired,
  projectId: PropTypes.string.isRequired,
  serviceId: PropTypes.string.isRequired,
  clusters: PropTypes.array.isRequired,
  errorMessage: PropTypes.string.isRequired,
};

export default ShardModalForm;
