import React from 'react';
import PropTypes from 'prop-types';

const LinkWithName = ({ name, children }) => (
  <div>
    {children}
    <br />
    <small>{name}</small>
  </div>
);

LinkWithName.propTypes = {
  name: PropTypes.string.isRequired,
  children: PropTypes.node.isRequired,
};

export default LinkWithName;
