import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import LabeledValue from '../../components/LabeledValue';
import { isCloud } from '../../utils/env';

export const QUOTA_IDS = {
  MAX_FILE_SENSORS_FORM_ID: 345030,
  MAX_MEMONLY_SENSORS_FORM_ID: 345031,
  MAX_RESPONSE_SIZE_FORM_ID: 345032,
  MAX_SENSORS_PER_URL_FORM_ID: 345046,
};

const isCloudEnv = isCloud();

class ShardQuotaField extends PureComponent {
  render() {
    const {
      quotaId, projectId, shardId, label, value, formatted,
    } = this.props;

    const formHref = `https://forms.yandex-team.ru/surveys/28780/?answer_short_text_220524=${projectId}&answer_short_text_220536__0=${shardId}&answer_choices_220533__0=${quotaId}&answer_number_220561__0=${value}`;

    const formattedValue = formatted ? value.toLocaleString('ru') : `${value}`;

    let valueContent;

    if (isCloudEnv) {
      valueContent = formattedValue;
    } else {
      valueContent = (
        <>
          {formattedValue}
          <br />
          <a href={formHref} target="_blank" rel="noopener noreferrer">
            <small>
              request quota change
            </small>
          </a>
        </>
      );
    }

    return (
      <LabeledValue
        label={label}
        value={valueContent}
      />
    );
  }
}

ShardQuotaField.propTypes = {
  quotaId: PropTypes.number.isRequired,
  projectId: PropTypes.string.isRequired,
  shardId: PropTypes.string.isRequired,
  label: PropTypes.string.isRequired,
  value: PropTypes.number.isRequired,
  formatted: PropTypes.bool.isRequired,
};

export default ShardQuotaField;
