/* eslint-disable max-len */
import React from 'react';
import PropTypes from 'prop-types';
import { convertColumnsToRows } from '../../../components/SolomonDash/convertColumnsToRows';
import SolomonDash from '../../../components/SolomonDash/SolomonDash';
import { shardGraphUrl, templateDashboardMap } from './utils';
import { knownDcs, isPreEnv } from '../../../utils/env';
import DashboardTimeSelector from '../../../components/SolomonDash/DashboardTimeSelector';
import { getMonitoringUiHost } from '../../old/utils/graphToExpressionTransformations';
import ViewNewButton from './ViewOldButton';

const FetchingGraphsView = (props) => {
  const {
    projectId,
    shardId,
    duration,
    viewNewVersion,
    onToggleViewNew,
  } = props;

  const columns = React.useMemo(() => {
    const tempColumns = [];

    for (let index = 0; index < knownDcs.length; index++) {
      const dc = knownDcs[index];
      const dcTitle = dc.title;
      const dcHost = dc.host;
      const fetchingStatusUrl = shardGraphUrl(dcHost, {
        service: 'fetcher',
        'l.sensor': 'fetch.urlStatus',
        'l.projectId': projectId,
        'l.shardId': shardId,
        'l.type': '*',
      });

      const responseSizeUrl = shardGraphUrl(dcHost, {
        service: 'fetcher',
        'l.sensor': 'fetch.responseByteSize',
        'l.projectId': projectId,
        'l.shardId': shardId,
      });

      const urlsCountUrl = shardGraphUrl(dcHost, {
        service: 'fetcher',
        'l.sensor': 'fetch.urlCount',
        'l.projectId': projectId,
        'l.shardId': shardId,
      });

      const downloadTimeUrl = shardGraphUrl(dcHost, {
        service: 'fetcher',
        'l.sensor': 'fetch.downloadMillis',
        'l.projectId': projectId,
        'l.shardId': shardId,
        'l.bin': '*',
      });

      const columnItems = [
        { title: 'Fetching Status', url: fetchingStatusUrl },
        { title: 'Response Size', url: responseSizeUrl },
        { title: 'Urls Count', url: urlsCountUrl },
        { title: 'Download time', url: downloadTimeUrl },
      ];

      tempColumns.push({ name: dcTitle, items: columnItems });
    }

    return tempColumns;
  }, [projectId, shardId]);

  const rows = convertColumnsToRows(columns);

  const host = getMonitoringUiHost();
  const dashId = isPreEnv()
    ? templateDashboardMap.fetching.pre
    : templateDashboardMap.fetching.prod;

  const iframeLink = `https://${host}/embed/${projectId}/dash/${dashId}?p.projectId=${projectId}&p.shardId=${shardId}&range=${duration}&refresh=60`;

  return (
    <div>
      <DashboardTimeSelector
        duration={duration}
        onChange={props.onDurationChange}
      >
        <ViewNewButton isNew={viewNewVersion} onToggle={onToggleViewNew} />
      </DashboardTimeSelector>
      {viewNewVersion ? (
        <iframe
          title="targets_status_graphs"
          height="752"
          width="100%"
          frameBorder="0"
          src={iframeLink}
        />
      ) : (
        <SolomonDash
          id="targets_status_graphs"
          rows={rows}
          duration={duration}
        />
      )}
    </div>
  );
};

FetchingGraphsView.propTypes = {
  projectId: PropTypes.string.isRequired,
  shardId: PropTypes.string.isRequired,
  duration: PropTypes.string.isRequired,
  onDurationChange: PropTypes.func.isRequired,
  viewNewVersion: PropTypes.bool.isRequired,
  onToggleViewNew: PropTypes.func.isRequired,
};

export default FetchingGraphsView;
