import React from 'react';
import PropTypes from 'prop-types';

import { convertColumnsToRows } from '../../../components/SolomonDash/convertColumnsToRows';
import SolomonDash from '../../../components/SolomonDash/SolomonDash';
import { isPreEnv, knownDcs } from '../../../utils/env';
import { shardGraphUrl, templateDashboardMap } from './utils';
import DashboardTimeSelector from '../../../components/SolomonDash/DashboardTimeSelector';
import ViewNewButton from './ViewOldButton';
import { getMonitoringUiHost } from '../../old/utils/graphToExpressionTransformations';

const MetricsGraphsView = (props) => {
  const {
    projectId,
    shardId,
    duration,
    viewNewVersion,
    onToggleViewNew,
  } = props;

  const columns = [];

  // eslint-disable-next-line no-restricted-syntax
  for (const dc of knownDcs) {
    const dcTitle = dc.title;
    const dcHost = dc.host;
    const fileSensorsUrl = shardGraphUrl(dcHost, {
      service: 'coremon',
      'l.sensor': 'engine.fileSensors|engine.fileSensorsLimit',
      'l.projectId': projectId,
      'l.shardId': shardId,
      stack: 'false',
    });

    const inMemorySensorsUrl = shardGraphUrl(dcHost, {
      service: 'coremon',
      'l.sensor': 'engine.inMemSensors|engine.inMemSensorsLimit',
      'l.projectId': projectId,
      'l.shardId': shardId,
      stack: 'false',
    });

    const columnItems = [
      {
        title: 'File metrics',
        url: fileSensorsUrl,
      },
      {
        title: 'In-memory metrics',
        url: inMemorySensorsUrl,
      },
    ];

    columns.push({
      name: dcTitle,
      items: columnItems,
    });
  }

  const rows = convertColumnsToRows(columns);

  const host = getMonitoringUiHost();
  const dashId = isPreEnv()
    ? templateDashboardMap.metricLimits.pre
    : templateDashboardMap.metricLimits.prod;

  const iframeLink = `https://${host}/embed/${projectId}/dash/${dashId}?p.projectId=${projectId}&p.shardId=${shardId}&range=${duration}&refresh=60`;

  return (
    <div>
      <DashboardTimeSelector
        duration={duration}
        onChange={props.onDurationChange}
      >
        <ViewNewButton isNew={viewNewVersion} onToggle={onToggleViewNew} />
      </DashboardTimeSelector>
      {viewNewVersion ? (
        <iframe
          title="sensor_limit_graphs"
          height="578"
          width="100%"
          frameBorder="0"
          src={iframeLink}
        />
      ) : (
        <SolomonDash id="sensor_limit_graphs" rows={rows} duration={duration} />
      )}
    </div>
  );
};

MetricsGraphsView.propTypes = {
  projectId: PropTypes.string.isRequired,
  shardId: PropTypes.string.isRequired,
  duration: PropTypes.string.isRequired,
  onDurationChange: PropTypes.func.isRequired,
  viewNewVersion: PropTypes.bool.isRequired,
  onToggleViewNew: PropTypes.func.isRequired,
};

export default MetricsGraphsView;
