/* eslint-disable no-restricted-syntax */
import React from 'react';
import PropTypes from 'prop-types';
import { convertColumnsToRows } from '../../../components/SolomonDash/convertColumnsToRows';
import SolomonDash from '../../../components/SolomonDash/SolomonDash';
import { shardGraphUrl, templateDashboardMap } from './utils';
import { isPreEnv, knownDcs } from '../../../utils/env';
import DashboardTimeSelector from '../../../components/SolomonDash/DashboardTimeSelector';
import ViewNewButton from './ViewOldButton';
import { getMonitoringUiHost } from '../../old/utils/graphToExpressionTransformations';

const ProcessingGraphsView = (props) => {
  const {
    projectId,
    shardId,
    duration,
    viewNewVersion,
    onToggleViewNew,
  } = props;

  const columns = [];

  for (const dc of knownDcs) {
    const dcTitle = dc.title;
    const dcHost = dc.host;
    const sensorsParseErrorsUrl = shardGraphUrl(dcHost, {
      service: 'coremon',
      'l.sensor': 'engine.sensorParseError',
      'l.type': '*',
      'l.projectId': projectId,
      'l.shardId': shardId,
    });

    const urlProcessResultUrl = shardGraphUrl(dcHost, {
      service: 'coremon',
      'l.sensor': 'engine.urlProcessResult',
      'l.projectId': projectId,
      'l.shardId': shardId,
    });

    const processSensorsUrl = shardGraphUrl(dcHost, {
      service: 'coremon',
      'l.sensor': 'engine.sensorsTotal',
      'l.projectId': projectId,
      'l.shardId': shardId,
    });

    const writersToStorageUrl = shardGraphUrl(dcHost, {
      service: 'coremon',
      'l.sensor': 'engine.stockpileWrites.completed*',
      'l.projectId': projectId,
      'l.shardId': shardId,
    });

    const columnItems = [
      { title: 'Metrics parse errors', url: sensorsParseErrorsUrl },
      { title: 'Url process result', url: urlProcessResultUrl },
      { title: 'Process metrics/s', url: processSensorsUrl },
      { title: 'Writers To Storage', url: writersToStorageUrl },
    ];

    columns.push({ name: dcTitle, items: columnItems });
  }

  const rows = convertColumnsToRows(columns);

  const host = getMonitoringUiHost();
  const dashId = isPreEnv()
    ? templateDashboardMap.processing.pre
    : templateDashboardMap.processing.prod;

  const iframeLink = `https://${host}/embed/${projectId}/dash/${dashId}?p.projectId=${projectId}&p.shardId=${shardId}&range=${duration}&refresh=60`;

  return (
    <div>
      <DashboardTimeSelector
        duration={duration}
        onChange={props.onDurationChange}
      >
        <ViewNewButton isNew={viewNewVersion} onToggle={onToggleViewNew} />
      </DashboardTimeSelector>
      {viewNewVersion ? (
        <iframe
          title="coremon_status_graphs"
          height="752"
          width="100%"
          frameBorder="0"
          src={iframeLink}
        />
      ) : (
        <SolomonDash
          id="coremon_status_graphs"
          rows={rows}
          duration={duration}
        />
      )}
    </div>
  );
};

ProcessingGraphsView.propTypes = {
  projectId: PropTypes.string.isRequired,
  shardId: PropTypes.string.isRequired,
  duration: PropTypes.string.isRequired,
  onDurationChange: PropTypes.func.isRequired,
  viewNewVersion: PropTypes.bool.isRequired,
  onToggleViewNew: PropTypes.func.isRequired,
};

export default ProcessingGraphsView;
