import React from 'react';
import PropTypes from 'prop-types';
import SolomonDash from '../../../components/SolomonDash/SolomonDash';
import { shardGraphUrl, templateDashboardMap } from './utils';
import DashboardTimeSelector from '../../../components/SolomonDash/DashboardTimeSelector';
import ViewNewButton from './ViewOldButton';
import { getMonitoringUiHost } from '../../old/utils/graphToExpressionTransformations';
import { isPreEnv } from '../../../utils/env';

const PushGraphsView = (props) => {
  const {
    projectId,
    shardId,
    duration,
    viewNewVersion,
    onToggleViewNew,
  } = props;

  const pushStatusUrl = shardGraphUrl('cluster', {
    service: 'gateway',
    'l.sensor': 'push.shard.requests.total',
    'l.projectId': projectId,
    'l.shardId': shardId,
    'l.sensorsFormat': 'total',
    'l.pushStatus': '!NOT_OK',
  });

  const pushProcessedSensorsUrl = shardGraphUrl('cluster', {
    service: 'gateway',
    'l.sensor': 'push.shard.sensorsProcessed',
    'l.projectId': projectId,
    'l.shardId': shardId,
    'l.sensorsFormat': 'total',
  });

  const rows = [
    {
      items: [{ title: 'Push status', url: pushStatusUrl }],
    },
    {
      items: [
        { title: 'Push processed metrics, /s', url: pushProcessedSensorsUrl },
      ],
    },
  ];

  const host = getMonitoringUiHost();
  const dashId = isPreEnv()
    ? templateDashboardMap.push.pre
    : templateDashboardMap.push.prod;

  const iframeLink = `https://${host}/embed/${projectId}/dash/${dashId}?p.projectId=${projectId}&p.shardId=${shardId}&range=${duration}&refresh=60`;

  return (
    <div>
      <DashboardTimeSelector
        duration={duration}
        onChange={props.onDurationChange}
      >
        <ViewNewButton isNew={viewNewVersion} onToggle={onToggleViewNew} />
      </DashboardTimeSelector>
      {viewNewVersion ? (
        <iframe
          title="push_graphs"
          height="404"
          width="100%"
          frameBorder="0"
          src={iframeLink}
        />
      ) : (
        <SolomonDash id="push_graphs" rows={rows} duration={duration} />
      )}
    </div>
  );
};

PushGraphsView.propTypes = {
  projectId: PropTypes.string.isRequired,
  shardId: PropTypes.string.isRequired,
  duration: PropTypes.string.isRequired,
  onDurationChange: PropTypes.func.isRequired,
  viewNewVersion: PropTypes.bool.isRequired,
  onToggleViewNew: PropTypes.func.isRequired,
};

export default PushGraphsView;
