import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import Modal from '../../../components/Modal';
import StatusLabel from './StatusLabel';

class ShardStatusesModal extends PureComponent {
  onHideShardStatuses = (event) => {
    if (event) {
      event.preventDefault();
    }
    this.props.onClearShardStatuses();
  };

  render() {
    let shardStatusesModal = null;

    if (this.props.shardStatuses.length) {
      const shardStatuses = (
        <div>
          <table className="table table-condensed table-hover">
            <thead>
              <tr>
                <th>#</th>
                <th>Shard id</th>
                <th>
                  Write Status
                  &nbsp;
                  <a
                    href="https://wiki.yandex-team.ru/solomon/userguide/FAQ/#error-types"
                    target="_blank"
                    rel="noopener noreferrer"
                  >
                    <i className="glyphicon glyphicon-info-sign" />
                  </a>
                </th>
                <th>Metrics Parsed</th>
                <th>Error</th>
              </tr>
            </thead>
            <tbody>
              {this.props.shardStatuses.map((ss, i) => (
                // eslint-disable-next-line react/no-array-index-key
                <tr key={i}>
                  <td>{i + 1/* TODO(ivanzhukov): pagination */}</td>
                  <td>{ss.shardId/* TODO(ivanzhukov): make a clickable url */}</td>
                  <td><StatusLabel status={ss.lastStatus} /></td>
                  <td>{ss.lastSensorsParsed}</td>
                  <td>{ss.lastError}</td>
                </tr>
              ))}
            </tbody>
          </table>
        </div>
      );

      shardStatusesModal = (
        <Modal title={this.props.url} isOpen large onCancel={this.onHideShardStatuses}>
          {shardStatuses}
        </Modal>
      );
    }

    return shardStatusesModal;
  }
}

ShardStatusesModal.propTypes = {
  url: PropTypes.string.isRequired,
  shardStatuses: PropTypes.array.isRequired,
  onClearShardStatuses: PropTypes.func.isRequired,
};

export default ShardStatusesModal;
