import PropTypes from 'prop-types';
import React from 'react';

const StatusLabel = ({ status }) => {
  let style;
  if (status === 'OK') {
    style = 'success';
  } else {
    style = (status === 'UNKNOWN_STATUS_TYPE') ? 'info' : 'danger';
  }
  return <span className={`label label-${style}`}>{status}</span>;
};

StatusLabel.propTypes = {
  status: PropTypes.string.isRequired,
};

export default StatusLabel;
