/* eslint-disable no-restricted-syntax */
import React from 'react';
import PropTypes from 'prop-types';
import { convertColumnsToRows } from '../../../components/SolomonDash/convertColumnsToRows';
import SolomonDash from '../../../components/SolomonDash/SolomonDash';
import { stockpileShardGraphUrl, templateDashboardMap } from './utils';
import { isPreEnv, knownDcs } from '../../../utils/env';
import DashboardTimeSelector from '../../../components/SolomonDash/DashboardTimeSelector';
import { getMonitoringUiHost } from '../../old/utils/graphToExpressionTransformations';
import ViewNewButton from './ViewOldButton';

const StorageGraphsView = (props) => {
  const {
    shardNumId,
    duration,
    projectId,
    viewNewVersion,
    onToggleViewNew,
  } = props;

  const columns = [];

  for (const dc of knownDcs) {
    const { title: dcTitle, spCluster } = dc;
    const spShardBytesCount = stockpileShardGraphUrl(spCluster, {
      'l.sensor': 'stockpile.host.bytes.count',
      'l.kind': 'total',
      'l.level': 'total',
      'l.ownerId': shardNumId,
    });

    const spShardRecordCount = stockpileShardGraphUrl(spCluster, {
      'l.sensor': 'stockpile.host.record.count',
      'l.kind': 'total',
      'l.level': 'total',
      'l.ownerId': shardNumId,
    });

    const spShardMetricsCount = stockpileShardGraphUrl(spCluster, {
      'l.sensor': 'stockpile.host.sensors.count',
      'l.kind': 'total',
      'l.level': 'total',
      'l.ownerId': shardNumId,
    });

    const spShardReadRecordsRate = stockpileShardGraphUrl(spCluster, {
      'l.sensor': 'stockpile.read.records.rate',
      'l.kind': 'total',
      'l.producer': 'total',
      'l.ownerId': shardNumId,
    });

    const spShardReadMetricsRate = stockpileShardGraphUrl(spCluster, {
      'l.sensor': 'stockpile.read.sensors.rate',
      'l.kind': 'total',
      'l.producer': 'total',
      'l.ownerId': shardNumId,
    });

    const spShardWriteRecordsRate = stockpileShardGraphUrl(spCluster, {
      'l.sensor': 'stockpile.write.records.rate',
      'l.kind': 'total',
      'l.producer': 'total',
      'l.ownerId': shardNumId,
    });

    const spShardWriteMetricsRate = stockpileShardGraphUrl(spCluster, {
      'l.sensor': 'stockpile.write.sensors.rate',
      'l.kind': 'total',
      'l.producer': 'total',
      'l.ownerId': shardNumId,
    });

    const columnItems = [
      {
        title: 'Store bytes',
        url: spShardBytesCount,
      },
      {
        title: 'Store points',
        url: spShardRecordCount,
      },
      {
        title: 'Store metrics',
        url: spShardMetricsCount,
      },
      {
        title: 'Read points/sec',
        url: spShardReadRecordsRate,
      },
      {
        title: 'Read metrics/sec',
        url: spShardReadMetricsRate,
      },
      {
        title: 'Write points/sec',
        url: spShardWriteRecordsRate,
      },
      {
        title: 'Write metrics/sec',
        url: spShardWriteMetricsRate,
      },
    ];

    columns.push({
      name: dcTitle,
      items: columnItems,
    });
  }

  const rows = convertColumnsToRows(columns);

  const host = getMonitoringUiHost();
  const dashId = isPreEnv()
    ? templateDashboardMap.storage.pre
    : templateDashboardMap.storage.prod;

  const iframeLink = `https://${host}/embed/${projectId}/dash/${dashId}?p.ownerId=${shardNumId}&range=${duration}&refresh=60`;

  return (
    <div>
      <DashboardTimeSelector
        duration={duration}
        onChange={props.onDurationChange}
      >
        <ViewNewButton isNew={viewNewVersion} onToggle={onToggleViewNew} />
      </DashboardTimeSelector>
      {viewNewVersion ? (
        <iframe
          title="stockpile_status_graphs"
          height="1274"
          width="100%"
          frameBorder="0"
          src={iframeLink}
        />
      ) : (
        <SolomonDash
          id="stockpile_status_graphs"
          rows={rows}
          duration={duration}
        />
      )}
    </div>
  );
};

StorageGraphsView.propTypes = {
  shardNumId: PropTypes.string.isRequired,
  duration: PropTypes.string.isRequired,
  projectId: PropTypes.string.isRequired,
  onDurationChange: PropTypes.func.isRequired,
  viewNewVersion: PropTypes.bool.isRequired,
  onToggleViewNew: PropTypes.func.isRequired,
};

export default StorageGraphsView;
