import React from 'react';
import PropTypes from 'prop-types';
import { isPreOrProdIntEnv } from '../../../utils/env';

const ViewNewButton = ({ onToggle, isNew }) => {
  if (!isPreOrProdIntEnv()) {
    return null;
  }

  return (
    <label style={{ fontWeight: 'normal' }}>
      <input
        type="checkbox"
        style={{ margin: 0, verticalAlign: 'middle' }}
        checked={isNew}
        onChange={onToggle}
      />
      &nbsp;New Version
    </label>
  );
};

ViewNewButton.propTypes = {
  onToggle: PropTypes.func.isRequired,
  isNew: PropTypes.bool.isRequired,
};

export default ViewNewButton;
