/* eslint-disable no-dupe-keys */
import { formatSearch } from '../../../utils/url';
import { projectForEnv, coreClusterForEnv } from '../../../utils/env';

export function shardGraphUrl(host, params) {
  return `/?${formatSearch({
    project: projectForEnv,
    cluster: coreClusterForEnv,
    host,
    ...params,
    graph: 'auto',
    autorefresh: false,
  })}`;
}

export function stockpileShardGraphUrl(cluster, params) {
  return `/?${formatSearch({
    project: projectForEnv,
    cluster,
    service: 'stockpile_resources',
    host: 'cluster',
    ...params,
    graph: 'auto',
    autorefresh: false,
  })}`;
}

export const templateDashboardMap = {
  fetching: {
    pre: 'mongprmqqr5gdskr1e6k',
    prod: 'monuntcmuvdc3mnotnod',
  },
  push: {
    pre: 'moneari8ig1vpbpl6duv',
    prod: 'monujna6foijjt8jlhdd',
  },
  processing: {
    pre: 'mon03to8ne59hlt7rich',
    prod: 'monjq1mp857cpkk04cih',
  },
  storage: {
    pre: 'monholf6boe32vbf3qse',
    prod: 'monn8k9gnjc0bsqduc8s',
  },
  metricLimits: {
    pre: 'monpt42ef4ku8t4mg75f',
    prod: 'monrp1k10c22gk9mudfh',
  },
};

export default {};
