import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import { Link } from 'react-router-dom';
import RadioButtons from '../../components/RadioButtons';
import { ITEM_STATE_TITLES, ITEM_STATES } from '../../utils/itemState';

class ShardsToolbar extends PureComponent {
  componentDidMount() {
    this.filterInput.focus();
  }

  handleFilterChange = (event) => {
    event.preventDefault();
    this.props.onFilterChange(event);
  };

  handleShardStateChange = (state) => {
    this.props.onShardStateChange(state);
  };

  render() {
    const { createNewLink, filter, shardState } = this.props;

    let newButton = null;

    if (createNewLink) {
      newButton = (
        <Link to={createNewLink} className="btn btn-outline btn-success">
          <i className="glyphicon glyphicon-plus" />
          {' '}
          Create New
        </Link>
      );
    }

    return (
      <div className="btn-toolbar table-toolbar">
        <div className="btn-group">
          {newButton}
        </div>
        <div className="btn-group">
          <input
            type="text"
            className="form-control"
            placeholder="Type to filter..."
            defaultValue={filter}
            onChange={this.handleFilterChange}
            ref={(input) => { this.filterInput = input; }}
            tabIndex={0}
          />
        </div>
        <div className="pull-right">
          <RadioButtons
            choices={ITEM_STATES}
            labels={ITEM_STATE_TITLES}
            selected={shardState}
            onSelect={this.handleShardStateChange}
          />
        </div>
      </div>
    );
  }
}

ShardsToolbar.propTypes = {
  filter: PropTypes.string.isRequired,
  shardState: PropTypes.string.isRequired,
  createNewLink: PropTypes.string,
  onFilterChange: PropTypes.func.isRequired,
  onShardStateChange: PropTypes.func.isRequired,
};

ShardsToolbar.defaultProps = {
  createNewLink: null,
};

export default ShardsToolbar;
