import React from 'react';
import PropTypes from 'prop-types';
import { BrowserRouter as Router } from 'react-router-dom';

import Header from '../../components/Header';
import WarningAlert from '../projects/alerts/WarningAlert';
import BrowserUtils from '../../utils/BrowserUtils';

import './style.css';

const UnavailableServicePage = ({ tryToReload }) => {
  const message = `Service is unavailable${tryToReload ? ', try to reload...' : ''}`;

  if (BrowserUtils.inIframe()) {
    return (
      <div style={{ textAlign: 'center' }}>
        {message}
      </div>
    );
  }

  return (
    <Router>
      <div>
        <Header />
        <div id="unavailable-page-wrapper">
          <WarningAlert title="Error" message={message} />
        </div>
      </div>
    </Router>
  );
};

UnavailableServicePage.propTypes = {
  tryToReload: PropTypes.bool.isRequired,
};

export default UnavailableServicePage;
