import React from 'react';
import PropTypes from 'prop-types';
import {
  BrowserRouter,
  Route,
  Switch,
  // Redirect,
} from 'react-router-dom';
import { connect } from 'react-redux';

import Header from '../components/Header';
import TopLevelAlerts from '../components/TopLevelAlerts';
import Sidebar from '../components/Sidebar/Sidebar';
import AlertsList from '../components/AlertsList';
import YmHitListener from '../components/YmHitListener';

import OldMainPage from '../pages/old/OldMainPage';

import ProjectsPage from '../pages/projects/ProjectsPage';
import ProjectsSelectPage from '../pages/projects/ProjectsSelectPage';
import ProjectsSelectForMultipleAlertsPage from '../pages/projects/ProjectsSelectForMultipleAlertsPage';
import ProjectPage from '../pages/projects/ProjectPage';
import ProjectStatusPage from '../pages/projects/ProjectStatusPage';
import { EditProjectPage, NewProjectPage } from '../pages/projects/ProjectEditPage';
import ProjectMenuPage from '../pages/projects/ProjectMenuPage';

import ServicePage from '../pages/services/ServicePage';
import ServiceEditPage from '../pages/services/ServiceEditPage';
import ServicesPage from '../pages/services/ServicesPage';

import ClusterPage from '../pages/clusters/ClusterPage';
import ClusterEditPage from '../pages/clusters/ClusterEditPage';
import ClustersPage from '../pages/clusters/ClustersPage';

import ShardPage from '../pages/shards/ShardPage';
import ShardEditPage from '../pages/shards/ShardEditPage';
import ShardsPage from '../pages/shards/ShardsPage';
import ShardStatusPage from '../pages/shards/ShardStatusPage/ShardStatusPage';

import AlertsPage from '../pages/alerts/AlertsPage';
import AlertStatesPage from '../pages/alerts/AlertStatesPage/AlertStatesPage';
import AlertPage from '../pages/alerts/AlertPage/AlertPage';
import AlertSinglestatPage from '../pages/alerts/AlertSinglestatPage/AlertSinglestatPage';
import SubAlertsPage from '../pages/alerts/SubAlertsPage/SubAlertsPage';
import SubAlertsNotificationsPage from '../pages/alerts/SubAlertsNotificationsPage/SubAlertsNotificationsPage';
import SubAlertPage from '../pages/alerts/SubAlertPage';
import AlertEditPage from '../pages/alerts/AlertEditPage/AlertEditPage';
import AlertsNewAlertPage from '../pages/alerts/AlertsNewAlertPage';
import AlertsTemplatesPage from '../pages/alerts/AlertsTemplatesPage';
import AlertsTemplatesMultipleResources from '../pages/alerts/AlertsTemplatesMultipleResources';

import ChannelsPage from '../pages/channels/ChannelsPage';
import ChannelPage from '../pages/channels/ChannelPage';
import ChannelEditPage from '../pages/channels/ChannelEditPage';

import MutesPage from '../pages/mutes/MutesPage';
import MutePage from '../pages/mutes/MutePage';
import MuteEditPage from '../pages/mutes/MuteEditPage';

import DashboardsPage from '../pages/dashboards/DashboardsPage';
import DashboardPage from '../pages/dashboards/DashboardPage';
import DashboardEditPage from '../pages/dashboards/DashboardEditPage';

import GraphsPage from '../pages/graphs/GraphsPage';
import GraphPage from '../pages/graphs/GraphPage';
import GraphEditPage from '../pages/graphs/GraphEditPage';

import MetricsPage from '../pages/metrics/MetricsPage';
import RawMetricsPage from '../pages/metrics/RawMetricsPage';
import StrictValidationPage from '../pages/metrics/StrictValidationPage';

import AutoGraphPage from '../pages/data/AutoGraphPage';
import StockpileMetricPage from '../pages/data/StockpileMetricPage/StockpileMetricPage';

import AgentsPage from '../pages/serviceProviders/AgentsPage';
import ServiceDashboardEditPage from '../pages/serviceProviders/ServiceDashboardEditPage';
import ServiceDashboardPage from '../pages/serviceProviders/ServiceDashboardPage';
import ServiceDashboardsPage from '../pages/serviceProviders/ServiceDashboardsPage';
import ServiceProviderEditPage from '../pages/serviceProviders/ServiceProviderEditPage';
import ServiceProviderPage from '../pages/serviceProviders/ServiceProviderPage';
import ServiceProvidersPage from '../pages/serviceProviders/ServiceProvidersPage';

import GlobalClustersPage from '../pages/clusters/GlobalClustersPage';
import GlobalServicesPage from '../pages/services/GlobalServicesPage';
import GlobalShardsPage from '../pages/shards/GlobalShardsPage';
import GlobalGraphsPage from '../pages/graphs/GlobalGraphsPage';
import GlobalDashboardsPage from '../pages/dashboards/GlobalDashboardsPage';

import PreferencesPage from '../pages/PreferencesPage/PreferencesPage';
import NotFoundPage from '../pages/notFound/NotFoundPage';

import { getProjectFeatureFlags } from '../store/reducers/projects/projectFeatureFlags';

import './Root.css';

class ProjectRelatedRoutes extends React.Component {
  componentDidMount() {
    this.props.getProjectFeatureFlags(this.props.match.params.projectId);
  }

  render() {
    return (
      <Switch>
        {/* More specific URLs (more long to be simpler) must precede more general */}
        <Route exact path="/admin/projects/:projectId/services/:serviceId/edit" component={ServiceEditPage} />
        <Route exact path="/admin/projects/:projectId/services/new" component={ServiceEditPage} />
        <Route exact path="/admin/projects/:projectId/services/:serviceId" component={ServicePage} />
        <Route exact path="/admin/projects/:projectId/services" component={ServicesPage} />

        <Route exact path="/admin/projects/:projectId/clusters/:clusterId/edit" component={ClusterEditPage} />
        <Route exact path="/admin/projects/:projectId/clusters/new" component={ClusterEditPage} />
        <Route exact path="/admin/projects/:projectId/clusters/:clusterId" component={ClusterPage} />
        <Route exact path="/admin/projects/:projectId/clusters" component={ClustersPage} />

        <Route exact path="/admin/projects/:projectId/shards/:shardId/status" component={ShardStatusPage} />
        <Route exact path="/admin/projects/:projectId/shards/:shardId/targets" component={ShardStatusPage} />
        <Route exact path="/admin/projects/:projectId/shards/:shardId/edit" component={ShardEditPage} />
        <Route exact path="/admin/projects/:projectId/shards/new" component={ShardEditPage} />
        <Route exact path="/admin/projects/:projectId/shards/:shardId" component={ShardPage} />
        <Route exact path="/admin/projects/:projectId/shards" component={ShardsPage} />

        <Route exact path="/admin/projects/:projectId/alerts" component={AlertsPage} />
        <Route exact path="/admin/projects/:projectId/alertStates" component={AlertStatesPage} />
        <Route exact path="/admin/projects/:projectId/alerts/choose" component={AlertsNewAlertPage} />
        <Route exact path="/admin/projects/:projectId/alerts/templates" component={AlertsTemplatesPage} />
        <Route exact path="/admin/projects/:projectId/alerts/templates/multipleResources" component={AlertsTemplatesMultipleResources} />
        <Route exact path="/admin/projects/:projectId/alerts/new" component={AlertEditPage} />
        <Route exact path="/admin/projects/:projectId/alerts/:alertId" component={AlertPage} />
        <Route exact path="/admin/projects/:projectId/alerts/:alertId/singlestat" component={AlertSinglestatPage} />
        <Route exact path="/admin/projects/:projectId/alerts/:alertId/subAlerts" component={SubAlertsPage} />
        <Route exact path="/admin/projects/:projectId/alerts/:alertId/subAlertsNotifications" component={SubAlertsNotificationsPage} />
        <Route exact path="/admin/projects/:projectId/alerts/:alertId/subAlerts/:subAlertId" component={SubAlertPage} />
        <Route exact path="/admin/projects/:projectId/alerts/:alertId/subAlerts/:subAlertId/singlestat" component={AlertSinglestatPage} />
        <Route exact path="/admin/projects/:projectId/alerts/:alertId/edit" component={AlertEditPage} />

        <Route exact path="/admin/projects/:projectId/channels" component={ChannelsPage} />
        <Route exact path="/admin/projects/:projectId/channels/new" component={ChannelEditPage} />
        <Route exact path="/admin/projects/:projectId/channels/:channelId" component={ChannelPage} />
        <Route exact path="/admin/projects/:projectId/channels/:channelId/edit" component={ChannelEditPage} />

        <Route exact path="/admin/projects/:projectId/mutes" component={MutesPage} />
        <Route exact path="/admin/projects/:projectId/mutes/new" component={MuteEditPage} />
        <Route exact path="/admin/projects/:projectId/mutes/:muteId" component={MutePage} />
        <Route exact path="/admin/projects/:projectId/mutes/:muteId/edit" component={MuteEditPage} />

        <Route exact path="/admin/projects/:projectId/dashboards/:dashboardId/edit" component={DashboardEditPage} />
        <Route exact path="/admin/projects/:projectId/dashboards/new" component={DashboardEditPage} />
        <Route exact path="/admin/projects/:projectId/dashboards/:dashboardId" component={DashboardPage} />
        <Route exact path="/admin/projects/:projectId/dashboards" component={DashboardsPage} />

        <Route exact path="/admin/projects/:projectId/graphs/:graphId/edit" component={GraphEditPage} />
        <Route exact path="/admin/projects/:projectId/graphs/new" component={GraphEditPage} />
        <Route exact path="/admin/projects/:projectId/graphs/:graphId" component={GraphPage} />
        <Route exact path="/admin/projects/:projectId/graphs" component={GraphsPage} />

        {/* Old sensors page */}
        <Route exact path="/admin/projects/:projectId/sensors" component={MetricsPage} />
        <Route exact path="/admin/projects/:projectId/invalidSensors" component={StrictValidationPage} />
        <Route exact path="/admin/projects/:projectId/rawSensors" component={RawMetricsPage} />
        <Route exact path="/admin/projects/:projectId/stockpileSensor" component={StockpileMetricPage} />
        <Route exact path="/admin/projects/:projectId/metrics" component={MetricsPage} />
        <Route exact path="/admin/projects/:projectId/invalidMetrics" component={StrictValidationPage} />
        <Route exact path="/admin/projects/:projectId/strictValidation" component={StrictValidationPage} />
        <Route exact path="/admin/projects/:projectId/rawMetrics" component={RawMetricsPage} />
        <Route exact path="/admin/projects/:projectId/stockpileMetric" component={StockpileMetricPage} />
        <Route exact path="/admin/projects/:projectId/autoGraph" component={AutoGraphPage} />

        <Route exact path="/admin/projects/:projectId/menu" component={ProjectMenuPage} />
        <Route exact path="/admin/projects/:projectId/status" component={ProjectStatusPage} />
        <Route exact path="/admin/projects/:projectId/edit" component={EditProjectPage} />

        <Route exact path="/admin/projects/:projectId" component={ProjectPage} />
      </Switch>
    );
  }
}

ProjectRelatedRoutes.propTypes = {
  match: PropTypes.object.isRequired,
  getProjectFeatureFlags: PropTypes.func.isRequired,
};

const ConnectedProjectRoutes = connect(null, { getProjectFeatureFlags })(ProjectRelatedRoutes);

const ProjectPageRouter = () => (
  <div>
    <Header />
    <Sidebar />
    <AlertsList />

    <div id="page-wrapper">
      <TopLevelAlerts admin />
      <Switch>
        <Route exact path="/admin/projects/new" component={NewProjectPage} />
        <Route exact path="/admin/projects" component={ProjectsPage} />
        <Route exact path="/admin/selectProjectsForAlerts" component={ProjectsSelectPage} />
        <Route exact path="/admin/selectProjectForMultipleAlerts" component={ProjectsSelectForMultipleAlertsPage} />

        <Route path="/admin/projects/:projectId" component={ConnectedProjectRoutes} />

        <Route exact path="/admin/shards" component={GlobalShardsPage} />
        <Route exact path="/admin/clusters" component={GlobalClustersPage} />
        <Route exact path="/admin/services" component={GlobalServicesPage} />
        <Route exact path="/admin/graphs" component={GlobalGraphsPage} />
        <Route exact path="/admin/dashboards" component={GlobalDashboardsPage} />
        <Route exact path="/admin/preferences" component={PreferencesPage} />

        <Route exact path="/admin/serviceProviders" component={ServiceProvidersPage} />
        <Route exact path="/admin/serviceProviders/new" component={ServiceProviderEditPage} />
        <Route exact path="/admin/serviceProviders/:serviceProviderId" component={ServiceProviderPage} />
        <Route exact path="/admin/serviceProviders/:serviceProviderId/edit" component={ServiceProviderEditPage} />
        <Route exact path="/admin/serviceProviders/:serviceProviderId/agents" component={AgentsPage} />
        <Route exact path="/admin/serviceProviders/:serviceProviderId/serviceDashboards" component={ServiceDashboardsPage} />
        <Route exact path="/admin/serviceProviders/:serviceProviderId/serviceDashboards/new" component={ServiceDashboardEditPage} />
        <Route exact path="/admin/serviceProviders/:serviceProviderId/serviceDashboards/:serviceDashboardId" component={ServiceDashboardPage} />
        <Route exact path="/admin/serviceProviders/:serviceProviderId/serviceDashboards/:serviceDashboardId/edit" component={ServiceDashboardEditPage} />

        <Route exact path="/admin/" component={ProjectsPage} />

        <Route path="*" component={NotFoundPage} />
      </Switch>
    </div>
  </div>
);

const Root = () => (
  <BrowserRouter>
    <>
      <YmHitListener />
      <Switch>
        <Route exact path="/" component={OldMainPage} />
        <Route exact path="/admin/old" component={OldMainPage} />
        <Route exact path="/admin/projects/:projectId/alerts/:alertId/subAlerts/fullscreen" component={SubAlertsPage} />
        <Route exact path="/admin/projects/:projectId/alerts/:alertId/singlestat/fullscreen" component={AlertSinglestatPage} />
        <Route exact path="/admin/projects/:projectId/alerts/:alertId/subAlerts/:subAlertId/singlestat/fullscreen" component={AlertSinglestatPage} />
        <Route exact path="/admin/projects/:projectId/alertStates/fullscreen" component={AlertStatesPage} />
        <Route path="*" component={ProjectPageRouter} />
      </Switch>
    </>
  </BrowserRouter>
);

export default Root;
