class BarsGeom {
  static BAR_PADDING_IN_PERCENTS = 0.1;

  /**
   * @param {ChartGeom} chartGeom
   * @param {number} barCount
   */
  constructor(chartGeom, barCount) {
    this.chartGeom = chartGeom;
    this.barCount = barCount;
    this.barPadding = Math.trunc(this.getBarWidthNoPadding() * BarsGeom.BAR_PADDING_IN_PERCENTS);
    this.barWidth = this.getBarRight(0) - this.getBarLeft(0);
  }

  getBarLeft(index) {
    return this.getBarLeftNoPadding(index) + this.barPadding;
  }

  // Inverse barLeft
  getBarIndexFromBarLeft(barLeft) {
    return this.getBarIndexFromBarLeftNoPadding(barLeft - this.barPadding);
  }

  getBarLeftNoPadding(index) {
    return Math.trunc((this.chartGeom.chartAreaWidth * index) / this.barCount);
  }

  // Inverse barLeftNoPadding
  getBarIndexFromBarLeftNoPadding(barLeft) {
    return Math.trunc((barLeft * this.barCount) / this.chartGeom.chartAreaWidth);
  }

  getBarRight(index) {
    return this.getBarRightNoPadding(index) - this.barPadding;
  }

  getBarRightNoPadding(index) {
    return this.getBarLeftNoPadding(index + 1);
  }

  getBarMiddle(index) {
    return (this.getBarLeftNoPadding(index) + this.getBarRightNoPadding(index)) / 2;
  }

  getBarWidth() {
    return this.barWidth;
  }

  getBarWidthNoPadding() {
    return this.getBarRightNoPadding(0) - this.getBarLeftNoPadding(0);
  }

  getBarIndexFromCursorX(barPosition) {
    const index = this.getBarIndexFromBarLeft(barPosition);
    const barLeft = this.getBarLeft(index);
    const barRight = this.getBarRight(index);
    return barLeft <= barPosition && barPosition <= barRight ? index : -1;
  }
}

export default BarsGeom;
