import ChartCommon from '../common/ChartCommon';
import ChartBarsCommon from './ChartBarsCommon';
import ChartDistribution from './ChartDistrubution';
import ChartBars from './ChartBars';

class ChartBarsWithDistributionFallback {
  /**
   * @param {GraphFormatter} graphFormatter
   * @param {Element} $where
   * @param {AggrValue[]} values
   * @param {ChartConf} conf
   * @param {number} chartBorderWidth
   * @param {boolean} distributionMode
   */
  static chart(
    graphFormatter,
    $where,
    values,
    conf,
    chartBorderWidth,
    distributionMode,
  ) {
    const valuesToShow = ChartCommon.filterNotNan(ChartCommon.filterShow(values));

    // eslint-disable-next-line max-len
    const chartBars = ChartBarsCommon.makeChartBarsCommon($where, valuesToShow, conf, chartBorderWidth);

    const isManyValues = ChartDistribution.isManyValues(chartBars, valuesToShow);

    if (distributionMode || isManyValues) {
      ChartDistribution.chart(chartBars, graphFormatter, valuesToShow, conf);
    } else {
      ChartBars.chart(chartBars, graphFormatter, valuesToShow, conf);
    }
  }
}

export default ChartBarsWithDistributionFallback;
