import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import GraphConfUtils from '../../pages/old/OldGraphPage/utils/GraphConfUtils';
import ReactChartBars from './ReactChartBars';

class GraphModeBars extends PureComponent {
  render() {
    const {
      aggrValues, graphConf, distributionMode, graphFormatter,
    } = this.props;

    const chartConf = GraphConfUtils.toChartConf(graphConf);

    return (
      <ReactChartBars
        graphFormatter={graphFormatter}
        aggrValues={aggrValues}
        conf={chartConf}
        chartBorderWidth={2}
        distributionMode={distributionMode}
      />
    );
  }
}

GraphModeBars.propTypes = {
  aggrValues: PropTypes.array.isRequired,
  graphConf: PropTypes.object.isRequired,
  distributionMode: PropTypes.bool.isRequired,
  graphFormatter: PropTypes.object.isRequired,
};

export default GraphModeBars;
