import React, { Component } from 'react';
import PropTypes from 'prop-types';
import isEqual from 'lodash/isEqual';

import ChartBarsWithDistributionFallback from './ChartBarsWithDistributionFallback';

class ReactChartBars extends Component {
  componentDidMount() {
    this._drawChart();
  }

  shouldComponentUpdate(nextProps) {
    return !isEqual(this.props.conf, nextProps.conf)
      || !isEqual(this.props.aggrValues, nextProps.aggrValues)
      || this.props.chartBorderWidth !== nextProps.chartBorderWidth
      || this.props.distributionMode !== nextProps.distributionMode;
  }

  componentDidUpdate() {
    this._el.innerHTML = '';
    this._drawChart();
  }

  _drawChart() {
    ChartBarsWithDistributionFallback.chart(
      this.props.graphFormatter,
      this._el,
      this.props.aggrValues,
      this.props.conf,
      this.props.chartBorderWidth,
      this.props.distributionMode,
    );
  }

  render() {
    return (
      <div
        className="chart-root-div"
        style={{ width: '100%', height: '100%', position: 'relative' }}
        ref={(el) => { this._el = el; }}
      />
    );
  }
}

ReactChartBars.propTypes = {
  aggrValues: PropTypes.array.isRequired,
  conf: PropTypes.object.isRequired,
  chartBorderWidth: PropTypes.number.isRequired,
  distributionMode: PropTypes.bool.isRequired,
  graphFormatter: PropTypes.object.isRequired,
};

export default ReactChartBars;
