/* eslint-disable no-continue */
export function computeMinAbs(data, extractor) {
  let minAbs = 0;

  for (let i = 0; i < data.length; ++i) {
    let v = extractor(data[i]);
    if (v === null || isNaN(v)) {
      continue;
    }

    v = Math.abs(v);
    if (v !== 0 && (minAbs === 0 || v < minAbs)) {
      minAbs = v;
    }
  }
  return minAbs;
}

export function computePositiveMaxOrZero(values) {
  let max = 0;
  for (let i = 0; i < values.length; ++i) {
    const { value } = values[i];
    if (!(value === null || isNaN(value)) && value > max) {
      max = value;
    }
  }
  return max;
}

export function computeNegativeMinOrZero(values) {
  let min = 0;
  for (let i = 0; i < values.length; ++i) {
    const { value } = values[i];
    if (!(value === null || isNaN(value)) && value < min) {
      min = value;
    }
  }
  return min;
}
