/* eslint-disable import/no-cycle */
import YaxisCommon from './YaxisCommon';
import LogYAxisTransformer from './LogYAxisTransformer';
import YAxisScaleData from './YAxisScaleData';

class Axis {
  /**
   * @param {number} min
   * @param {number} max
   * @param {boolean} log
   * @param {number} chartAreaHeight
   * @param {number} minAbs
   * @param {number} minValue
   * @param {number} offsetLeft
   * @param {number} minYaxisAreaWidth
   */
  constructor(
    min,
    max,
    log,
    chartAreaHeight,
    minAbs,
    minValue,
    offsetLeft,
    minYaxisAreaWidth,
  ) {
    this.min = min;
    this.max = max;
    this.range = max - min;

    this.minAbs = minAbs;
    this.minValue = minValue;
    this.chartAreaHeight = chartAreaHeight;

    this.logTransformer = log ? new LogYAxisTransformer(chartAreaHeight, min, max, minAbs) : null;

    this.ticks = YaxisCommon.makeYAxisTicks(
      new YAxisScaleData(min, max, minAbs, minValue),
      YaxisCommon.MIN_YAXIS_TICK_HEIGHT,
      chartAreaHeight,
      log,
    );

    this.areaWidth = YaxisCommon.computeYaxisAreaWidth(this.ticks, minYaxisAreaWidth);
    this.offsetLeft = offsetLeft;
    this.minYaxisAreaWidth = minYaxisAreaWidth;
  }

  copyWithNewOffsetLeft(offsetLeft) {
    return new Axis(
      this.min,
      this.max,
      this.isLog(),
      this.chartAreaHeight,
      this.minAbs,
      this.minValue,
      offsetLeft,
      this.minYaxisAreaWidth,
    );
  }

  dataYToChartAreaY(y) {
    if (this.logTransformer != null) {
      return this.logTransformer.yToChartY(y);
    }

    if (this.range === 0) {
      return this.chartAreaHeight / 2;
    }

    const v = (1 - ((y - this.min) / this.range)) * this.chartAreaHeight;
    if (v < -this.chartAreaHeight) {
      return -this.chartAreaHeight;
    }

    return v;
  }

  isLog() {
    return this.logTransformer != null;
  }

  getTicks() {
    return this.ticks;
  }
}

export default Axis;
