class CommonChartElements {
  /**
   * @param {Element} $chartRootDiv
   * @param {SVGElement} $chartAreaWithBorder
   * @param {SVGElement} $chartArea
   * @param {SVGElement} $xaxisArea
   * @param {object} $yaxisAreas
   * @param {ChartGeom} geom
   */
  constructor(
    $chartRootDiv,
    $chartAreaWithBorder,
    $chartArea,
    $xaxisArea,
    $yaxisAreas,
    geom,
  ) {
    this.$chartRootDiv = $chartRootDiv;
    this.chartAreaWithBorderHeight = geom.chartAreaWithBorderHeight;
    this.yaxisAreasSummaryWidth = geom.getYaxisAreasSummaryWidth();
    this.chartAreaWithBorderWidth = geom.chartAreaWithBorderWidth;
    this.$chartAreaWithBorder = $chartAreaWithBorder;
    this.chartAreaWidth = geom.chartAreaWidth;
    this.chartAreaHeight = geom.chartAreaHeight;
    this.$chartArea = $chartArea;
    this.$xaxisArea = $xaxisArea;
    this.geom = geom;
    this.$yaxisAreas = $yaxisAreas;
  }
}

export default CommonChartElements;
