class SvgDBuilder {
  constructor() {
    this.sb = '';
  }

  loop() {
    this.sb += ' Z';
  }

  line(x, y) {
    this.sb += ` L ${x} ${y}`;
  }

  lineV(y) {
    this.sb += ` V ${y}`;
  }

  lineH(x) {
    this.sb += ` H ${x}`;
  }

  move(x, y) {
    this.sb += ` M ${x}, ${y}`;
  }

  moveSharp(x, y, strokeWidth) {
    const sharpX = SvgDBuilder.sharp(x, strokeWidth);
    const sharpY = SvgDBuilder.sharp(y, strokeWidth);
    this.move(sharpX, sharpY);
  }

  lineSharp(x, y, strokeWidth) {
    const sharpX = SvgDBuilder.sharp(x, strokeWidth);
    const sharpY = SvgDBuilder.sharp(y, strokeWidth);
    this.line(sharpX, sharpY);
  }

  static sharp(coord, strokeWidth) {
    if (strokeWidth % 2 !== 0) {
      return Math.trunc(coord) + 0.5;
    }

    return coord;
  }

  arc(rx, ry, xaxisRotation, largeArc, sweepFlag, x, y) {
    this.sb += ` A ${rx} ${ry} ${xaxisRotation} ${largeArc ? 1 : 0} ${sweepFlag ? 1 : 0} ${x} ${y}`;
  }

  format() {
    return this.sb;
  }
}

export default SvgDBuilder;
