/* eslint-disable no-param-reassign,no-plusplus */
import SvgUtils from '../svg/SvgUtils';

class TextFit {
  static fitTextWithDotsIfNeeded(
    maxLabelWidth,
    labelPrefix,
    necessaryPostfix,
    cssClass,
  ) {
    const currentLabel = labelPrefix + necessaryPostfix;
    const currentLabelWidth = Math.trunc(SvgUtils.measureTextSize(currentLabel, cssClass).width);
    if (currentLabelWidth <= maxLabelWidth) {
      return currentLabel;
    }

    const newLabelWidth = 0.9 * maxLabelWidth;
    const newLabelLen = Math.trunc((newLabelWidth / currentLabelWidth) * currentLabel.length);
    const newPrefixLen = newLabelLen - necessaryPostfix.length;
    if (newPrefixLen >= 4) {
      return `${labelPrefix.substring(0, newPrefixLen)}...${necessaryPostfix}`;
    }

    return '';
  }
}

export default TextFit;
