class YAxisScaleData {
  /**
   * @param {number} min
   * @param {number} max
   * @param {number} minAbs
   * @param {number} minValue
   */
  constructor(min, max, minAbs, minValue) {
    this.min = min;
    this.max = max;
    this.minAbs = minAbs;
    this.minValue = minValue;
  }

  getMin() {
    return this.min;
  }

  getMax() {
    return this.max;
  }

  /**
   * @return {number} smallest non-zero absolute value displayed on the axis
   * or 0 if no such values were found.
   */
  getMinAbs() {
    return this.minAbs;
  }

  range() {
    return this.max - this.min;
  }

  getMinValue() {
    return this.minValue;
  }
}

export default YAxisScaleData;
