import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import UserLinksBasic from '../../utils/UserLinksBasic';
import parseKmg from '../../utils/Kmg';
import ReactChartHeatmap from './ReactChartHeatmap';

function getColorFromQueryArg(graphConf, arg) {
  const value = graphConf[arg];
  if (!value) {
    return NaN;
  }

  return parseKmg(value);
}

class GraphModeHeatmap extends PureComponent {
  render() {
    const { aggrValues, graphConf, graphFormatter } = this.props;

    const heatmapColorValues = {
      green: getColorFromQueryArg(graphConf, UserLinksBasic.HEATMAP_GREEN_VALUE_QUERY_ARG),
      yellow: getColorFromQueryArg(graphConf, UserLinksBasic.HEATMAP_YELLOW_VALUE_QUERY_ARG),
      red: getColorFromQueryArg(graphConf, UserLinksBasic.HEATMAP_RED_VALUE_QUERY_ARG),
      violet: getColorFromQueryArg(graphConf, UserLinksBasic.HEATMAP_VIOLET_VALUE_QUERY_ARG),
    };

    const isLog = graphConf.scale === UserLinksBasic.SCALE_LOG;

    const conf = {
      heatmapColorValues,
      isLog,
    };

    return (
      <ReactChartHeatmap
        aggrValues={aggrValues}
        conf={conf}
        graphFormatter={graphFormatter}
      />
    );
  }
}

GraphModeHeatmap.propTypes = {
  aggrValues: PropTypes.array.isRequired,
  graphConf: PropTypes.object.isRequired,
  graphFormatter: PropTypes.object.isRequired,
};

export default GraphModeHeatmap;
