import React, { Component } from 'react';
import PropTypes from 'prop-types';
import isEqual from 'lodash/isEqual';

import ChartHeatmap from './ChartHeatmap';

class ReactChartHeatmap extends Component {
  componentDidMount() {
    this._drawChart();
  }

  shouldComponentUpdate(nextProps) {
    return !isEqual(this.props.aggrValues, nextProps.aggrValues)
      || !isEqual(this.props.conf, nextProps.conf);
  }

  componentDidUpdate() {
    this._el.innerHTML = '';
    this._drawChart();
  }

  _drawChart() {
    ChartHeatmap.chart(
      this.props.graphFormatter,
      this._el,
      this.props.aggrValues,
      this.props.conf,
    );
  }

  render() {
    return (
      <div
        className="chart-root-div"
        style={{ width: '100%', height: '100%', position: 'relative' }}
        ref={(el) => { this._el = el; }}
      />
    );
  }
}

ReactChartHeatmap.propTypes = {
  aggrValues: PropTypes.array.isRequired,
  conf: PropTypes.object.isRequired,
  graphFormatter: PropTypes.object.isRequired,
};

export default ReactChartHeatmap;
