class BinarySearch {
  /**
   * Find lower bound index in range [0, size]:
   * - if size is 0, it return 0
   * - find first index whose value >= target value;
   * - if target value is less than every value, it returns 0;
   * - if target value is greater than every value, it returns size.
   */
  static lowerBound(size, indexToValueExtractor, targetValue) {
    return BinarySearch.firstIndex(size, (index) => {
      const value = indexToValueExtractor(index);
      return value >= targetValue;
    });
  }

  static firstIndex(size, predicate) {
    let res = size;
    let l = 0;
    let r = size - 1;
    while (l <= r) {
      const mid = l + Math.trunc((r - l) / 2);
      if (predicate(mid)) {
        res = mid;
        r = mid - 1;
      } else {
        l = mid + 1;
      }
    }
    return res;
  }
}

export default BinarySearch;
