/* eslint-disable max-len */
import template from 'lodash/template';
import TextFit from '../common/TextFit';

import './style.css';

const hoverTemplate = template(`
<table class="hover-body">
        <tr>
            <td>
                <div class="solomon-color-square">
                    <div style="background-color: <%- color %>"></div>
                </div>
            </td>
            <td class="hover-label">
                <%- label %>
            </td>
            <td class="hover-number-value">
                <div class="hover-value-max" style="visibility: hidden; height: 0"></div>
                <div class="hover-value-sel"><%- value %></div>
            </td>
            <% if(percents) { %>
            <td class="hover-number-value">
                <div class="hover-value-sel"><%- percents %></div>
            </td>
            <% } %>
        </tr>
    </table>
`);

class ChartValueHover {
  /**
   * @param {AggrValue} aggrValue
   * @param {number} left
   * @param {number} top
   * @param {Element} $chartRootDiv
   * @param {{ format: function }} formatter
   * @return {Element}
   */
  static drawHover(aggrValue, left, top, $chartRootDiv, formatter) {
    ChartValueHover.killHover($chartRootDiv);

    const value = formatter.format(aggrValue.value);
    const croppedLabel = TextFit.fitTextWithDotsIfNeeded($chartRootDiv.clientWidth, aggrValue.label, '', '');

    const $hover = document.createElement('div');
    $hover.className = 'hover';
    $hover.style.position = 'absolute';
    $hover.style.left = `${left}px`;
    $hover.style.top = `${top}px`;

    $hover.innerHTML = hoverTemplate({
      label: croppedLabel,
      value,
      color: aggrValue.color,
      percents: aggrValue.percents,
    });

    $chartRootDiv.appendChild($hover);
    return $hover;
  }

  static drawHoverWithRightBoundary(value, left, top, rightBoundary, $chartRootDiv, graphFormatter) {
    const $hover = ChartValueHover.drawHover(value, left, top, $chartRootDiv, graphFormatter);

    // Don't draw hover righter than chart
    const maxLeft = rightBoundary - $hover.clientWidth;
    if (left > maxLeft) {
      $hover.style.left = `${maxLeft}px`;
    }
  }

  static killHover($chartRootDiv) {
    const $el = $chartRootDiv.querySelector('.hover');
    if ($el) {
      $el.parentElement.removeChild($el);
    }
  }
}

export default ChartValueHover;
