import SvgDBuilder from '../common/SvgDBuilder';
import SvgUtils from '../svg/SvgUtils';
import { removeElementsBySelector } from '../common/SelectorUtils';

class CursorHover {
  static drawCursor($chartArea, chartAreaX) {
    const d = new SvgDBuilder();
    d.move(chartAreaX, 0);
    d.lineV(10000);

    const $path = SvgUtils.createPathElement();
    $path.setAttribute('class', 'chart-v-cursor');
    $path.setAttribute('d', d.format());
    $chartArea.appendChild($path);
  }

  static drawPoint($chartArea, chartAreaX, chartAreaY, color) {
    const $circle = SvgUtils.createCircleElement();
    $circle.setAttribute('r', '4');
    $circle.setAttribute('cx', `${chartAreaX}`);
    $circle.setAttribute('cy', `${chartAreaY}`);

    $circle.setAttribute('stroke', color);
    $circle.setAttribute('stroke-width', '2');
    $circle.setAttribute('fill', 'none');

    $circle.setAttribute('class', 'chart-highlight-circle');

    $chartArea.appendChild($circle);
  }

  static clearCursorAndPoints($chartArea) {
    CursorHover.clearCursor($chartArea);
    CursorHover.clearPoints($chartArea);
  }

  static clearCursor($chartArea) {
    removeElementsBySelector($chartArea, '.chart-v-cursor');
  }

  static clearPoints($chartArea) {
    removeElementsBySelector($chartArea, '.chart-highlight-circle');
  }
}

export default CursorHover;
