import React, { Component } from 'react';
import PropTypes from 'prop-types';
import isEqual from 'lodash/isEqual';

import ChartLines from './ChartLines';
import GraphModeLinesHover from '../hover/GraphModeLinesHover';

import './style.css';

class ReactChartLines extends Component {
  componentDidMount() {
    this._drawChart();
  }

  shouldComponentUpdate(nextProps) {
    return !isEqual(this.props.conf, nextProps.conf)
      || !isEqual(this.props.lines, nextProps.lines)
      || this.props.chartBorderWidth !== nextProps.chartBorderWidth
      || this.props.hasMinYaxisAreaWidth !== nextProps.hasMinYaxisAreaWidth
      || this.props.borderColor !== nextProps.borderColor;
  }

  componentDidUpdate() {
    this._el.innerHTML = '';
    GraphModeLinesHover.killHover(this._hover, this._chart);
    this._drawChart();
  }

  componentWillUnmount() {
    if (this._chart) {
      this._chart.destroy();
    }
  }

  _drawChart() {
    if (this.props.debug) {
      console.time('render chart');
    }

    if (this._chart) {
      this._chart.destroy();
    }

    this._chart = ChartLines.chart(
      this._el,
      this.props.lines,
      this.props.conf,
      this.props.chartBorderWidth,
      this.props.hasMinYaxisAreaWidth,
      this.props.borderColor,
    );

    this._chart.setHoverListener(this.props.onHover);
    this._chart.setLeaveListener(this.props.onLeave);
    this._chart.setClickListener(this.props.onClick);
    this._chart.setSelectListener(this.props.onSelect);

    if (this.props.debug) {
      console.timeEnd('render chart');
    }
  }

  render() {
    return (
      <>
        <div
          className="chart-root-div"
          style={{ width: '100%', height: '100%', position: 'relative' }}
          ref={(el) => { this._el = el; }}
        />
        <div className="hover-placeholder" ref={(el) => { this._hover = el; }} />
      </>
    );
  }
}

ReactChartLines.propTypes = {
  lines: PropTypes.array.isRequired,
  conf: PropTypes.object.isRequired,
  chartBorderWidth: PropTypes.number.isRequired,
  hasMinYaxisAreaWidth: PropTypes.bool.isRequired,
  borderColor: PropTypes.string.isRequired,
  debug: PropTypes.bool,
  onHover: PropTypes.func,
  onLeave: PropTypes.func,
  onClick: PropTypes.func,
  onSelect: PropTypes.func,
};

ReactChartLines.defaultProps = {
  debug: false,
  onHover: null,
  onLeave: null,
  onClick: null,
  onSelect: null,
};

export default ReactChartLines;
