import React, { PureComponent } from 'react';
import PropTypes from 'prop-types';
import ReactChartPie from './ReactChartPie';

class GraphModePie extends PureComponent {
  render() {
    const { aggrValues, graphFormatter } = this.props;

    return (<ReactChartPie aggrValues={aggrValues} graphFormatter={graphFormatter} />);
  }
}

GraphModePie.propTypes = {
  aggrValues: PropTypes.array.isRequired,
  graphFormatter: PropTypes.object.isRequired,
};

export default GraphModePie;
