import React, { Component } from 'react';
import PropTypes from 'prop-types';
import isEqual from 'lodash/isEqual';

import ChartPie from './ChartPie';

class ReactChartPie extends Component {
  componentDidMount() {
    this._drawChart();
  }

  shouldComponentUpdate(nextProps) {
    return !isEqual(this.props.aggrValues, nextProps.aggrValues);
  }

  componentDidUpdate() {
    this._el.innerHTML = '';
    this._drawChart();
  }

  _drawChart() {
    ChartPie.chart(
      this.props.graphFormatter,
      this._el,
      this.props.aggrValues,
    );
  }

  render() {
    return (
      <div
        className="chart-root-div"
        style={{ width: '100%', height: '100%', position: 'relative' }}
        ref={(el) => { this._el = el; }}
      />
    );
  }
}

ReactChartPie.propTypes = {
  graphFormatter: PropTypes.object.isRequired,
  aggrValues: PropTypes.array.isRequired,
};

export default ReactChartPie;
