import TimelineNavigator from './TimelineNavigator';

class BaselineAsFunction {
  /**
   * @param {Baseline} baseline
   * @param {Interpolate} interpolate
   * @constructor
   */
  constructor(baseline, interpolate) {
    this.interpolate = interpolate;
    this.nav = new TimelineNavigator(baseline.getTimestamps());
    this.values = baseline.getTriples();
    this.timestamps = baseline.getTimestamps();
  }

  /**
   * @param {number} tsMillis
   * @param {TripleWhich} which
   * @return {number}
   */
  computeAt(tsMillis, which) {
    this.nav.scrollToMillis(tsMillis);
    if (this.nav.isOnPoint()) {
      return this.values[which][this.nav.getPos()];
    } if (this.nav.isBetweenPoints()) {
      return this.interpolate.interpolate(
        this.timestamps[this.nav.getPos()], this.values.rights[this.nav.getPos()],
        this.timestamps[this.nav.getPos() + 1], this.values.lefts[this.nav.getPos() + 1],
        tsMillis,
      );
    }

    return NaN;
  }
}

export default BaselineAsFunction;
