/* eslint-disable import/no-cycle */
import Baseline from './Baseline';
import Triples from './Triples';

class BaselineMath {
  /**
   * @param {Baseline} a
   * @param {Baseline} b
   * @return {Baseline}
   */
  static sum(a, b) {
    // sanity check
    if (a.timestamps.length !== b.timestamps.length) {
      throw new Error('different size of baselines');
    }

    const lefts = BaselineMath.sumImpl(a.getLefts(), b.getLefts());
    const middles = BaselineMath.sumImpl(a.getMiddles(), b.getMiddles());
    const rights = BaselineMath.sumImpl(a.getRights(), b.getRights());

    const triples = new Triples(lefts, middles, rights);

    return new Baseline(a.getTimestamps(), triples);
  }

  static sumImpl(a, b) {
    if (a.length !== b.length) {
      throw new Error('different sizes of timestamps');
    }
    const c = [];
    for (let i = 0; i < a.length; i++) {
      c[i] = a[i] + b[i];
    }
    return c;
  }
}

export default BaselineMath;
