/* eslint-disable import/no-cycle */
import TimelineUtils from './TimelineUtils';
import Baseline from './Baseline';

class BaselineMax {
  /**
   * @param {Baseline[]} baselines
   * @return Baseline
   */
  static max(baselines) {
    let max = Baseline.empty();

    baselines.forEach((baseline) => {
      max = BaselineMax.maxTwo(max, baseline);
    });

    return max;
  }

  /**
   * @param {Baseline} a
   * @param {Baseline} b
   * @return {Baseline}
   */
  static maxTwo(a, b) {
    if (a.isEmpty()) {
      return b;
    }
    if (b.isEmpty()) {
      return a;
    }

    const r = Baseline.empty();

    const visitBoth = (ts, ai, bi) => {
      const al = a.getLefts()[ai];
      const am = a.getMiddles()[ai];
      const ar = a.getRights()[ai];
      const bl = b.getLefts()[bi];
      const bm = b.getMiddles()[bi];
      const br = b.getRights()[bi];
      r.add(ts, Math.max(al, bl), Math.max(am, bm), Math.max(ar, br));
    };

    const visitLeft = (ts, ai) => {
      const al = a.getLefts()[ai];
      const am = a.getMiddles()[ai];
      const ar = a.getRights()[ai];
      r.add(ts, al, am, ar);
    };

    const visitRight = (ts, bi) => {
      const bl = b.getLefts()[bi];
      const bm = b.getMiddles()[bi];
      const br = b.getRights()[bi];
      r.add(ts, bl, bm, br);
    };

    TimelineUtils.visitCommonTimeline(a.timestamps, b.timestamps, visitLeft, visitRight, visitBoth);

    return r;
  }
}

export default BaselineMax;
