/* eslint-disable import/no-cycle */
import Baseline from './Baseline';
import Interpolate from './Interpolate';

class GraphDataToBaseline {
  /**
   * @param {GraphData} graphData
   * @param {Interpolate} interpolate
   * @return {Baseline}
   */
  static graphDataToBaseline(graphData, interpolate) {
    const { values } = graphData;
    const { timestamps } = graphData;
    const lefts = new Array(timestamps.length).fill(0);
    const middles = graphData.values.map((v) => (isNaN(v) ? 0 : v));
    const rights = new Array(timestamps.length).fill(0);

    if (interpolate === Interpolate.LINEAR) {
      for (let i = 0; i < timestamps.length; ++i) {
        if (i === 0) {
          lefts[i] = 0;
        } else if (!isNaN(values[i - 1])) {
          lefts[i] = middles[i];
        } else {
          lefts[i] = 0;
        }
        if (i === timestamps.length - 1) {
          rights[i] = 0;
        } else if (!isNaN(values[i + 1])) {
          rights[i] = middles[i];
        } else {
          rights[i] = 0;
        }
      }
    } else if (interpolate === Interpolate.LEFT) {
      for (let i = 1; i < timestamps.length; ++i) {
        if (isNaN(values[i])) {
          rights[i - 1] = 0;
          lefts[i] = 0;
        } else {
          rights[i - 1] = middles[i - 1];
          lefts[i] = middles[i - 1];
        }
      }
    } else if (interpolate === Interpolate.RIGHT) {
      for (let i = 0; i < timestamps.length - 1; ++i) {
        if (isNaN(values[i])) {
          rights[i] = 0;
          lefts[i + 1] = 0;
        } else {
          rights[i] = middles[i + 1];
          lefts[i + 1] = middles[i + 1];
        }
      }
    } else if (interpolate === Interpolate.NONE) {
      for (let i = 0; i < timestamps.length; ++i) {
        rights[i] = 0;
        lefts[i] = 0;
      }
    } else {
      throw new Error(`unknown interpolate: ${interpolate}`);
    }

    return Baseline.fromTripples(timestamps, lefts, middles, rights);
  }
}

export default GraphDataToBaseline;
