/* eslint-disable import/no-cycle */
import StackBuilder from './StackBuilder';
import Baseline from './Baseline';

class GraphDataToStripe {
  /**
   * @param {GraphData} graphData
   * @param {Interpolate} interpolate
   * @return {StripeIntermediate}
   */
  static graphDataToStripe(graphData, interpolate) {
    // `compine` is slower than implementation from scratch,
    // but easier to implement and maintain.
    return StackBuilder.combine(Baseline.empty(), graphData, interpolate)[1];
  }
}

export default GraphDataToStripe;
