/* eslint-disable prefer-destructuring */
class GraphDataUtils {
  static filterNonNan(graphData) {
    const newTimestamps = [];
    const newValues = [];

    for (let i = 0; i < graphData.values.length; ++i) {
      const ts = graphData.timestamps[i];
      const value = graphData.values[i];
      if (!isNaN(value)) {
        newTimestamps.push(ts);
        newValues.push(value);
      }
    }

    return { values: newValues, timestamps: newTimestamps };
  }

  static sparseNaNs(graphData) {
    const { length } = graphData.values;
    if (length <= 2) {
      return graphData;
    }
    const values = new Array(length);
    const ts = new Array(length);

    values[0] = graphData.values[0];
    values[length - 1] = graphData.values[length - 1];
    ts[0] = graphData.timestamps[0];
    ts[length - 1] = graphData.timestamps[length - 1];

    for (let i = 1; i < values.length - 1; i++) {
      values[i] = graphData.values[i];
      if (isNaN(values[i])) {
        ts[i] = (graphData.timestamps[i + 1] + graphData.timestamps[i - 1]) / 2;
      } else {
        ts[i] = graphData.timestamps[i];
      }
    }

    return { timestamps: ts, values };
  }
}

export default GraphDataUtils;
