import GraphDataUtils from './GraphDataUtils';

class GraphDataWithStackConfigAndCookie {
  graphData;

  // empty means new stack
  stack;

  down;

  cookie;

  yaxisPositionValue;

  /**
   * @param {GraphData} graphData
   * @param {String} stack
   * @param {boolean} down
   * @param {any} cookie
   * @param {string} yaxisPositionValue
   * @constructor
   */
  constructor(graphData, stack, down, cookie, yaxisPositionValue) {
    this.graphData = graphData;
    this.stack = stack;
    this.down = down;
    this.cookie = cookie;
    this.yaxisPositionValue = yaxisPositionValue;
  }

  getGraphData() {
    return this.graphData;
  }

  getStack() {
    return this.stack;
  }

  isDown() {
    return this.down;
  }

  getCookie() {
    return this.cookie;
  }

  getYaxisPositionValue() {
    return this.yaxisPositionValue;
  }

  sparseNaNs() {
    return new GraphDataWithStackConfigAndCookie(
      GraphDataUtils.sparseNaNs(this.graphData),
      this.stack,
      this.down,
      this.cookie,
      this.yaxisPositionValue,
    );
  }
}

export default GraphDataWithStackConfigAndCookie;
