import LinkedHashMap from '../../utils/LinkedHashMap';
import StackLines from './StackLines';

class GroupByStack {
  /**
   * @param {GraphDataWithStackConfigAndCookie[]} linesWithOrder
   * @return {StackLines[]}
   */
  static groupLinesByStack(linesWithOrder) {
    let anonStackIndex = 0;

    const r = new LinkedHashMap();
    // eslint-disable-next-line no-restricted-syntax
    for (const graphData of linesWithOrder) {
      if (!graphData.stack) {
        // generate stack id
        const stackId = `anon_stack_${anonStackIndex}`;
        anonStackIndex += 1;
        const key = { stackId, down: graphData.down };
        const keyJson = JSON.stringify(key);
        if (r.get(keyJson) !== null) {
          throw new Error(`key ${keyJson} already exists`);
        }
        r.put(keyJson, [graphData]);
      } else {
        const key = { stackId: graphData.stack, down: graphData.down };
        const keyJson = JSON.stringify(key);
        if (r.get(keyJson) === null) {
          r.put(keyJson, []);
        }
        r.get(keyJson).push(graphData);
      }
    }

    return r.entries()
      .map((e) => {
        const key = JSON.parse(e[0]);
        const value = e[1];
        return new StackLines(key.stackId, key.down, value);
      });
  }
}

export default GroupByStack;
