class Interpolate {
  static LINEAR = new Interpolate('linear');

  static LEFT = new Interpolate('left');

  static RIGHT = new Interpolate('right');

  static NONE = new Interpolate('none');

  static DEFAULT = Interpolate.LINEAR;

  static values = [
    Interpolate.LINEAR,
    Interpolate.LEFT,
    Interpolate.RIGHT,
    Interpolate.NONE,
  ];

  constructor(type) {
    this.type = type;
  }

  static parse(value) {
    if (!value) {
      return Interpolate.DEFAULT;
    }

    for (let i = 0; i < Interpolate.values.length; ++i) {
      const interpolate = Interpolate.values[i];
      if (interpolate.type === value) {
        return interpolate;
      }
    }
    throw new Error(`unknown interpolate value: ${value}`);
  }

  /**
   * @param {number} ax
   * @param {number} ay
   * @param {number} bx
   * @param {number} by
   * @param {number} cx
   * @return {number}
   */
  interpolate(ax, ay, bx, by, cx) {
    switch (this) {
      case Interpolate.LINEAR:
        return (((bx - cx) * ay) + ((cx - ax) * by)) / (bx - ax);
      case Interpolate.LEFT:
        return !isNaN(by) ? ay : NaN;
      case Interpolate.RIGHT:
        return !isNaN(ay) ? by : NaN;
      case Interpolate.NONE:
        return NaN;
      default:
        throw new Error('unknown interpolate');
    }
  }
}

export default Interpolate;
