import isEqual from 'lodash/isEqual';
import GraphDataAsFunction from './GraphDataAsFunction';

class Resampler {
  /**
   * @param {GraphData} graphData
   * @param {Timeline} timestamps,
   * @param {Interpolate} interpolate
   * @return {GraphData}
   */
  static resample(graphData, timestamps, interpolate) {
    if (isEqual(graphData.timestamps, timestamps)) {
      return graphData;
    }

    const func = new GraphDataAsFunction(graphData, interpolate);

    const values = new Array(timestamps.length);

    for (let i = 0; i < timestamps.length; ++i) {
      const leftTsMillis = timestamps[i === 0 ? i : i - 1];
      const tsMillis = timestamps[i];
      const rightTsMillis = timestamps[i === (timestamps.length - 1) ? i : i + 1];
      values[i] = func.computeAt(leftTsMillis, tsMillis, rightTsMillis);
    }

    return { timestamps, values };
  }
}

export default Resampler;
