class StackBuildResult {
  stack;

  upperBound;

  /**
   *
   * @param {List<Pair<StripeIntermediate, C>>} stack
   * @param {Baseline} upperBound
   */
  constructor(stack, upperBound) {
    this.stack = stack;
    this.upperBound = upperBound;
  }

  getStack() {
    return this.stack;
  }

  getUpperBound() {
    return this.upperBound;
  }

  mapValues(op) {
    const mappedStack = this.stack.map((pair) => [pair[0].mapValues(op), pair[1]]);

    const mappedUpperBound = this.upperBound.mapValues(op);

    return new StackBuildResult(mappedStack, mappedUpperBound);
  }

  neg() {
    return this.mapValues((d) => -d);
  }
}

export default StackBuildResult;
