import TimelineUtils from './TimelineUtils';

class StackLines {
  constructor(stackId, down, lines) {
    this.stackId = stackId;
    this.down = down;
    this.lines = lines;
  }

  makeCommonTimeline() {
    if (this.lines.length === 0) {
      throw new Error('lines are empty');
    }
    if (this.lines.length === 1) {
      return this.lines[0].graphData.timestamps;
    }

    const timelines = this.lines.map((line) => line.graphData.timestamps);

    return TimelineUtils.union(timelines);
  }

  sparseNaNs() {
    const lines = this.lines
      .map((line) => line.sparseNaNs());
    return new StackLines(this.stackId, this.down, lines);
  }
}

export default StackLines;
